/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.voxelshape;

import java.util.Objects;
import java.util.Optional;
import mod.chiselsandbits.api.axissize.CollisionType;
import mod.chiselsandbits.api.config.ICommonConfiguration;
import mod.chiselsandbits.api.multistate.accessor.IAreaAccessor;
import mod.chiselsandbits.api.multistate.accessor.identifier.IAreaShapeIdentifier;
import mod.chiselsandbits.api.voxelshape.IVoxelShapeManager;
import mod.chiselsandbits.utils.SimpleMaxSizedCache;
import mod.chiselsandbits.voxelshape.VoxelShapeCalculator;
import net.minecraft.class_2338;
import net.minecraft.class_259;
import net.minecraft.class_265;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class VoxelShapeManager
implements IVoxelShapeManager {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final VoxelShapeManager INSTANCE = new VoxelShapeManager();
    private final SimpleMaxSizedCache<Key, class_265> cache = new SimpleMaxSizedCache(ICommonConfiguration.getInstance().getCollisionBoxCacheSize().get());

    private VoxelShapeManager() {
    }

    public static VoxelShapeManager getInstance() {
        return INSTANCE;
    }

    @Override
    public class_265 get(IAreaAccessor accessor, class_2338 offset, CollisionType sizeType, boolean simplify) {
        Key cacheKey = new Key(accessor.createNewShapeIdentifier(), offset, sizeType, simplify);
        return this.cache.get(cacheKey, () -> {
            class_265 calculatedShape = VoxelShapeCalculator.calculate(accessor, offset, sizeType, simplify);
            if (calculatedShape.method_1110()) {
                return class_259.method_1073();
            }
            return calculatedShape;
        });
    }

    @Override
    public Optional<class_265> getCached(IAreaShapeIdentifier identifier, class_2338 offset, CollisionType sizeType, boolean simplify) {
        Key key = new Key(identifier, offset, sizeType, simplify);
        return this.cache.getIfPresent(key);
    }

    public void clearCache() {
        this.cache.clear();
    }

    private static final class Key {
        private final IAreaShapeIdentifier identifier;
        private final class_2338 offset;
        private final CollisionType sizeType;
        private final boolean simplify;

        private Key(IAreaShapeIdentifier identifier, class_2338 offset, CollisionType sizeType, boolean simplify) {
            this.identifier = identifier;
            this.offset = offset;
            this.sizeType = sizeType;
            this.simplify = simplify;
        }

        public String toString() {
            return "Key{identifier=" + this.identifier.toString() + ", offset=" + this.offset + ", predicate=" + this.sizeType + ", simplify=" + this.simplify + "}";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Key)) {
                return false;
            }
            Key key = (Key)o;
            if (this.simplify != key.simplify) {
                return false;
            }
            if (!Objects.equals(this.identifier, key.identifier)) {
                return false;
            }
            if (!Objects.equals(this.offset, key.offset)) {
                return false;
            }
            return Objects.equals((Object)this.sizeType, (Object)key.sizeType);
        }

        public int hashCode() {
            int result = this.identifier != null ? this.identifier.hashCode() : 0;
            result = 31 * result + (this.offset != null ? this.offset.hashCode() : 0);
            result = 31 * result + (this.sizeType != null ? this.sizeType.hashCode() : 0);
            result = 31 * result + (this.simplify ? 1 : 0);
            return result;
        }
    }
}

